model motor
  output Real w(start=0);
  output Real phi(start=0);
  input Real t2;
  Real t1(start=0);
  parameter Real J=1 "Inertia";
  parameter Real B=10 "Viscous friction";
  parameter Real w_ref=-200 "Reference speed";
  parameter Real Kp=50 "Controller gain";
equation
  der(w)*J+der(phi)*B = t1-t2;
  w=der(phi);
  t1=Kp*(w_ref-w);
end motor;
